// File created: 2007-10-18 14:15:13

package ope.adventure;

import java.util.List;

// For spells, that which is active and visible for the duration of the spell.
// For motions, used only to end motions at the correct time. Not visible to
// the player, only the endResults are.
public final class Effect implements Comparable<Effect> {
	private final String       name, desc, expireMsg;
	private final int          endingTime;
	private final List<Result> endResults;

	public Effect(
		final String n, final String d, final String e,
		final int t, final List<Result> r
	) {
		name = n;
		desc = d;
		expireMsg = e;
		endingTime = t;
		endResults = r;
	}

	public int compareTo(final Effect o) {
		return Integer.valueOf(endingTime).compareTo(o.getEndingTime());
	}

	// override equals to match compareTo...
	public boolean equals(final Object o) {
		return (o instanceof Effect) && endingTime == ((Effect)o).getEndingTime();
	}
	// ... and hashCode to match equals
	public int hashCode() {
		return endingTime;
	}

	public String       getName()              { return name; }
	public String       getDescription()       { return desc; }
	public String       getExpirationMessage() { return expireMsg; }
	public int          getEndingTime()        { return endingTime; }
	public List<Result> getResults()           { return endResults; }
}
