// File created: 2007-10-23 22:10:22

package ope.adventure;

import java.util.List;

public final class Spell {
	private final String name;
	private final int    castingTime, duration;
	private final List<Result> results;

	public String getName()        { return name; }
	public int    getCastingTime() { return castingTime; }

	// FIXME kludge, see Action.java
	private static int time;
	public  static void setTime(final int t) { time = t; }

	public Spell(
		final String n,
		final int c, final int d,
		final List<Result> r
	) {
		name        = n;
		castingTime = c;
		duration    = d;
		results     = r;
	}

	public String castBy(final Player player) {
		final Room room = player.getRoom();

		final Result res = Result.getResult(this.results, room.getEffectSet());

		if (res == null)
			throw new IllegalStateException(
				"Spell :: no result for spellcasting, " +
				"lack of a default should have been caught by parser");

		final Result.Consequences consequences = res.getConsequences();

		final boolean summoning = consequences.getEntity() != null;

		if (summoning) {
			if (!room.summoningAllowed())
				return
					"The spell fizzles. " +
					"Perhaps you aren't in the right kind of environment?";
			if (room.getEntity() != null)
				return
					"The presence of an entity prevents you from summoning another.";
		}

		if (!res.isSuccessful())
			return res.getMessage();

		final int timeOfCasting = this.time + this.castingTime;

		consequences.apply(player, timeOfCasting);

		// early return if quitting
		if (consequences.willQuit())
			return res.getMessage();

		room.addEffect(new Effect(
			this.name,
			consequences.getDescription(), consequences.getExpirationMessage(),
			timeOfCasting + this.duration,
			null));

		final Entity e = room.getEntity();
		if (e == null)
			return res.getMessage();
		else {
			final StringBuilder sb = new StringBuilder(res.getMessage());

			final String resp = e.responseTo(
				room.getEffectSet(),
				player, timeOfCasting);

			if (resp.length() > 0) {
				if (sb.length() > 0)
					sb.append("\n\n");
				sb.append(resp);
			}

			return sb.toString();
		}
	}
}
