// File created: 2007-10-21 19:51:37

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.book.Book;
import ope.adventure.book.ID;
import ope.adventure.util.Utils;

// "close" [book-identifier]
public final class CloseAction extends Action {
	public boolean doableWithoutBooks () { return false; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "close a book and put it where you got it from";
	}
	public String getLongHelp() {
		return
			"\"close\" book-identifier\n" +
			"\n" +
			"Close the identified book and place it where it came from - " +
			"exactly. You've had\nenough run-ins with the librarian to know " +
			"what will happen if you put it in the\nwrong place.";
	}

	public int perform(
		final List<String> words,
		final Configuration conf, final Player player
	) {
		if (words.isEmpty()) {
			if (player.isReading())
				return closeBook(player.popBook());
			else {
				println("You don't have a book to close.");
				return 0;
			}
		}

		ignoringExcess(words, 1);

		final Book book = ID.getBook(
			Utils.chomp(words.get(0), '.'),
			player.getPrevBooks());

		if (book == null) {
			println("Invalid book identifier. Check 'recent' for valid ones.");
			return 0;
		}

		if (player.stopReading(book))
			return super.closeBook(book);
		else {
			printfln(
				"You're not reading '%s'. Check 'reading'.",
				book.getShortTitle());
			return 0;
		}
	}
}
