// File created: 2007-10-25 17:15:14

package ope.adventure.actions;

import java.util.Arrays;
import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Entity;
import ope.adventure.Player;
import ope.adventure.Room;
import ope.adventure.util.Utils;

// "look" ["at"] [target]
public final class LookAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "look at something";
	}
	public String getLongHelp() {
		return
			"\"look\" [\"at\"] [target]\n" +
			"\"examine\" [\"at\"] [target]\n" +
			"\n" +
			"Look at target, outputting a description." +
			"\n\n" +
			"Used only for summoned entities and the assignment paper.";
	}

	public int perform(
		final List<String> words,
		final Configuration config, final Player player
	) {
		final Room room = player.getRoom();

		if (words.isEmpty())
			printfln(
				"%n%s%n%s",
				room.getName(),
				room.getFullDescription());
		else {
			if (
				!lookAt(Utils.join(words, " "), room, config, player) &&
				!(
					words.get(0).equals("at") &&
					lookAt(
						Utils.join(words.subList(1, words.size())),
						room, config, player))
			)
				println("That's not worth looking at.");
		}
		return 0;
	}

	private static boolean lookAt(
		final String target,
		final Room room, final Configuration config, final Player player
	) {
		if (target.length() == 0)
			return false;

		final Entity e = room.getEntity();

		if (e != null && e.getNames().contains(target)) {
			println(e.getAppearance());
			return true;
		}

		// XXX HACK HARDCODED
		// items in general are not implemented, we only need these two
		else if (player.getRoom() == Room.getStartingRoom()) {
			if (ASSIGNMENT_NAMES.contains(target)) {
				println(config.getAssignment());
				return true;

			} else if (target.equals("bell")) {
				println(
					"The chrome bell used for signalling an assistant to grade " +
					"you.");
				return true;
			}
		}

		return false;
	}

	private static final List<String> ASSIGNMENT_NAMES;
	static {
		final String[] ass = {
			"assignment", "task", "paper", "assignment paper", "task paper"};
		ASSIGNMENT_NAMES = Arrays.asList(ass);
	}
}
