// File created: 2007-10-25 12:32:47

package ope.adventure.actions;

import java.util.List;
import java.util.Random;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.Spell;
import ope.adventure.util.Utils;

// "cast" spell...
public final class MagicAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return false; }
	public boolean stopReading        () { return true; }

	public String getShortHelp() {
		return "perform some magic";
	}
	public String getLongHelp() {
		return
			"\"cast\" spell\n" +
			"\n" +
			"Cast spell. The effects depend on the spell in question.";
	}

	public int perform(
		final List<String> words,
		final Configuration config, final Player player
	) {
		if (words.isEmpty()) {
			println(
				"You cast your line into the sea, sit back, and relax...\n" +
				"And then you stop your daydreaming and remember that you're " +
				"not fishing.");
			return 1;
		}

		final String cant = player.getSpell(
			Utils.toLower(Utils.join(words, " ")));

		printfln(CAST_MESSAGES[random.nextInt(CAST_MESSAGES.length)], cant);
		println();

		final Spell spell = config.getSpells().get(cant);

		if (spell == null) {
			println("... but nothing happens.");
			return words.size();
		}

		final String msg = spell.castBy(player);
		if (msg.length() > 0)
			println(msg);

		return spell.getCastingTime();
	}

	private final Random random = new Random();

	private final String[] CAST_MESSAGES = {
		"You attune yourself to the flow of magic, mumbling '%s' quietly...",
		"You zestfully declare '%s' whilst calling forth the power within you...",
		"You hurriedly pronounce '%s', condensing your energy to cast the spell...",
		"You firmly recite the words '%s', manifesting your magical skill...",
		"The words '%s' flow from your mouth as you prepare to toss some magic...",
	};
}
