// File created: 2007-10-19 14:20:09

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.Room;
import ope.adventure.util.Utils;

// "go" ["to"] room-name
public final class MovementAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return true; }

	public String getShortHelp() {
		return "relocate oneself to target area";
	}
	public String getLongHelp() {
		return
			"\"go\" [\"to\"] room-name\n" +
			"\n" +
			"Go to room-name. There are three rooms, with the following " +
			"names:\n" +
			"     lobby\n" +
			"   library\n" +
			"laboratory\n" +
			"\n" +
			"No worrying about directions in this game - all rooms are " +
			"interconnected and\nmoving to another is a single command.";
	}

	public int perform(
		final List<String> words,
		final Configuration c, final Player player
	) {
		if (words.isEmpty()) {
			println("You have to go somewhere.");
			return 0;
		}

		String word = Utils.toLower(words.get(0));

		if (word.equals("to") && words.size() > 1) {
			word = Utils.toLower(words.get(1));
			ignoringExcess(words, 2);
		} else
			ignoringExcess(words, 1);

		if (word.equals("out") || word.equals("hall") || word.equals("hallway")) {
			println("That's not an option.");
			return 0;
		}

		final Room to = Room.getRoom(word);
		if (to == null) {
			printfln("No such room '%s'.", word);
			return 0;
		}

		final Room from = player.getRoom();
		if (to.equals(from)) {
			println("You're already there!");
			return 0;
		}

		stopReading(player);

		final int time = from.distanceTo(to);
		player.setRoom(to);
		return time;
	}
}
