// File created: 2007-10-19 20:32:44

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.book.Book;
import ope.adventure.book.BookSection;
import ope.adventure.book.ID;
import ope.adventure.util.Utils;

// "read" [book-identifier]
// "read" section-identifier
public final class ReadAction extends Action {
	public boolean doableWithoutBooks () { return false; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "read book or section";
	}
	public String getLongHelp() {
		return
			"\"read\" book-identifier\n" +
			"\"read\" section-identifier\n" +
			"\n" +
			"If given book-identifier, take corresponding book from shelf, " +
			"place it as the\nbook you are reading, and show its full name and " +
			"description." +
			"\n\n" +
			"If given section-identifier, read the corresponding section from " +
			"the book you\nare currently reading.";
	}

	public int perform(
		final List<String> words,
		final Configuration conf, final Player player
	) {
		if (words.isEmpty()) {
			if (player.isReading())
				printBook(player.topBook());
			else
				println("You don't have a book to read.");
			return 0;
		}

		ignoringExcess(words, 1);

		final String word = Utils.chomp(words.get(0), '.');

		if (ID.isSectionId(word)) {

			final BookSection s = ID.getSection(word, player.getPrevSections());
			if (s == null) {
				println(
					"Invalid section identifier. Check 'recent' for valid ones.");
				return 0;
			}

			printSection(s);
			return 1;

		} else if (ID.isBookId(word))
			return readBook(ID.getBook(word, player.getPrevBooks()), player);
		else {
			println(
				"You can't read something which is neither a book identifier nor "+
				"a section identifier.");
			return 0;
		}
	}

	private int readBook(final Book book, final Player player) {

		if (book == null) {
			println("Invalid book identifier. Check 'recent' for valid ones.");
			return 0;
		}

		if (player.topBook() == book) {
			println("You're already reading that book.");
			return 0;
		}

		if (player.stopReading(book)) {
			printfln("You start reading '%s' again.", book.getShortTitle());
			player.startReading(book);

			if (player.bookCount() >= 2 * BOOKSTACK_MSG_INTERVAL) {
				println("You have to dig a bit to find it...");
				return player.bookCount() / 2;
			} else
				return 1;
		}

// SAN not done

		printfln(
			"You grab '%s' from the shelf and start reading...",
			book.getShortTitle());

		player.startReading(book);

		final int bookCount = player.bookCount();
		int time = 0;

		if (bookCount >= BOOKSTACK_MSG_INTERVAL)
			println(LARGE_BOOKSTACK_MSGS[
				time = Math.min(
					bookCount / BOOKSTACK_MSG_INTERVAL,
					LARGE_BOOKSTACK_MSGS.length) - 1]);

		return time + 1;
	}

	private static final int BOOKSTACK_MSG_INTERVAL = 5;
	private static final String[] LARGE_BOOKSTACK_MSGS = {
		"You make some room for the books that are rapidly piling up.",
		"You build some haphazard piles for all the books you've got open.",
		"Your book piles collapse! You stack them neatly this time.",
		"Your stacks of books are getting taller than you are.",
		"Your book stacks stagger ominously.",
	};
}
