// File created: 2007-10-21 20:49:07

package ope.adventure.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.book.Book;
import ope.adventure.book.ID;

// "reading"
public final class ReadingAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "display list of books retrieved from the shelf";
	}
	public String getLongHelp() {
		return
			"\"reading\"\n" +
			"\n" +
			"Display the list of books retrieved from the shelf with the " +
			"\"read\" command." +
			"\n\n" +
			"Overwrites \"recent\".";
	}

	public int perform(
		final List<String> words,
		final Configuration conf, final Player player
	) {
		ignoringExcess(words, 0);

		if (player.bookCount() == 0)
			println("You're not reading anything.");
		else {
			println("You are reading the following books:");

			List<Book> books = player.getPrevBooks();
			if (books == null)
				books = new ArrayList<Book>();
			else
				books.clear();

			ID.resetBookId();
			for (
				final Iterator<Book> i = player.bookStackIterator();
				i.hasNext();
			) {
				final Book book = i.next();
				books.add(book);
				printBookId(book);
			}

			player.setNextBooks(books);
		}

		return 0;
	}
}
