// File created: 2007-11-02 22:36:56

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Entity;
import ope.adventure.Player;
import ope.adventure.Room;

// "ring" ["bell"]
public final class RingAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	// can't be done outside lobby anyway
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "ring the bell, signaling an assistant that you're done";
	}
	public String getLongHelp() {
		return
			"\"ring\" [\"bell\"]\n" +
			"\"use\" [\"bell\"]\n" +
			"\n" +
			"Ring the bell in the lobby, calling for an assistant to grade your " +
			"efforts.\nDoable only in the lobby.";
	}

	public int perform(
		final List<String> words,
		final Configuration config, final Player player
	) {
		// XXX HACK HARDCODED
		// items in general are not implemented but this is one of the two we need

		if (words.size() > 1 && words.get(1).equals("bell"))
			ignoringExcess(words, 2);
		else
			ignoringExcess(words, 1);

		if (player.getRoom() != Room.getStartingRoom()) {
			println("There is no bell here.");
			return 0;
		}

		println(
			"You ring the bell a few times. It makes no sound, but it " +
			"immediately turns red\nin colour. A few moments later, it starts " +
			"shifting towards green. When it\nresembles lime you hear footsteps " +
			"from outside the door. As the door swings open\nand the bell " +
			"assumes its original colour, a typically skinny and bored-looking\n" +
			"assistant no doubt delighted to be here is revealed." +
			"\n");


		println(
			"You are summarily ignored as the assistant rushes towards the " +
			"laboratory. Before\nyou can react and follow, you find your work " +
			"has been appraised, and the\nassistant is already going. \"You'll " +
			"get your results in a few weeks,\" you are\npromised, as the " +
			"assistant leaves down the hall." +
			"\n\n" +
			"In a few weeks, you look at the scoreboard..." +
			"\n==========================");

		Entity ent = null;
		for (final Room room : Room.getRooms()) {
			ent = room.getEntity();
			if (ent != null)
				break;
		}

		if (ent == null)
			println(
				"You got --- zero --- points.\n" +
				"Summoning something before calling the assistant may have been " +
				"a good idea.");
		else {
			final byte score = ent.getWorth();
			printfln("You got --- %d --- points.\n", ent.getWorth());
			if (score < 50)
				println(
					"Unfortunately, not enough to pass the course." +
					"\n\n" +
					"Fortunately, you get the job you wanted anyway, as you find " +
					"that nobody cares\nabout your degree as long as you have one.");
			else
				println(
					"That's enough to pass the course!" +
					"\n\n" +
					"You get the job you wanted and live happily ever after.");
		}

		player.endGame();
		return 1;
	}
}
