// File created: 2007-10-30 19:30:00

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;

// "wait" [integer]
public final class WaitAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "do nothing for a time";
	}
	public String getLongHelp() {
		return
			"\"wait\" [integer]\n" +
			"\n" +
			"Do nothing for integer turns, or one turn if unspecified.";
	}

	public int perform(
		final List<String> words,
		final Configuration c, final Player p
	) {
		if (words.isEmpty()) {
			println("You wait a moment.");
			return 1;
		} else {
			ignoringExcess(words, 1);

			final String time = words.get(0);
			try {
				final int t = Integer.parseInt(time);
				if (t < 0)
					println("Nice try, but you can't go back in time.");
				else if (t == 0)
					println("You begin to wait, but decide not to.");
				else if (t > Player.MAX_TIME) {
					println("You wait for a _LONG_ time. Just what did you expect?");
					return Player.MAX_TIME;
				} else
					println("You wait around for a while.");

				return t;

			} catch (NumberFormatException e) {
				println("You can't wait for a non-integral time.");
				return 0;
			}
		}
	}
}
