// File created: 2007-10-04 16:26:30

package ope.adventure.book;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import ope.adventure.Area;

public final class Book extends Area implements Comparable<Book> {

// SAN	private final byte    sanityNeed,  sanityCost;
	private final boolean referenced,  hasReference;
	private final String  description, shortTitle;

	private final Map<String, List<BookSection>> contents;

	private final Set<String> keywords = new TreeSet<String>();

	public Book(
		final String  name,       final String  desc, final String shortTitle,
		final byte    sanNeed,    final byte    sanCost,
		final boolean referenced, final boolean hasIndex,
		final Map<String, List<BookSection>> contents
	) {
		super.setName(name);
		this .shortTitle   = shortTitle;
		this .description  = desc;
  // SAN 	this .sanityNeed   = sanNeed;
  // SAN 	this .sanityCost   = sanCost;
		this .referenced   = referenced;
		this .hasReference = hasIndex;
		this .contents     = contents;

		this.keywords.addAll(contents.keySet());
	}

	// required by UI
	public String getFullDescription() { return description; }

	public String            getShortTitle() { return shortTitle; }
	public Set<String>       getKeywords()   { return keywords; }
	public List<BookSection> getSections(final String keyword) {
		return contents.get(keyword);
	}

	public boolean hasIndex()     { return hasReference; }
	public boolean isReferenced() { return referenced; }

	public int compareTo(final Book o) {
		return getName().compareTo(o.getName());
	}

	// override equals to match compareTo...
	public boolean equals(final Object o) {
		return (o instanceof Book) && getName().equals(((Book)o).getName());
	}
	// ... and hashCode to match equals
	public int hashCode() {
		return getName().hashCode();
	}
}
