// File created: 2007-10-24 17:01:18

package ope.adventure.parsers;

import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ope.adventure.Entity;
import ope.adventure.Result;
import ope.adventure.Spell;
import ope.adventure.util.BooleanExpression;
import ope.adventure.util.Utils;

public final class SummonSpellParser {
	private SummonSpellParser() {}

	private static String spellName;
	private static int castingTime, spellDuration;

	private static List<Result>
		results = new ArrayList<Result>();

	// the Entity is stored as a Consequence of the Spell
	public static Spell parse(final String textFile) {

		// FIXME
		// lots of duplication from SpellParser here... needs refactoring

		final Scanner scan = new Scanner(textFile);

		spellName = SpellParser.readName(scan);

		scan.useDelimiter("\\s+");

		castingTime   = scan.nextInt();
		spellDuration = scan.nextInt();

		scan.useDelimiter("$");

		final String rest = scan.next();
		int i = 0;
		boolean gotDefault = false;

		final Entity entity = new Entity();

		do try {
			final Result res = ResultParser.parse(
				rest.substring(i, rest.length()),
				SummonSpellConsequencePredicate.getInstance());

			i += ResultParser.getEnd();

			if (res.getCondition().getSym() == BooleanExpression.Symbol.DEFAULT)
				gotDefault = true;

			res.addConsequence(Result.Consequence.Type.SUMMON, entity);

			results.add(res);

			i = Utils.skipWhiteSpace(i, rest);

		} catch (final Exception e) {
			System.err.printf(
				"SummonSpellParser :: %s while parsing spell %s%n", e, spellName);

		} while (i < rest.length() && rest.charAt(i) == '(');

		if (!gotDefault)
			throw new BadEntityException("summon spell must have default result");

		i += readNames(rest.substring(i, rest.length()), entity);

		if (i >= rest.length())
			throw new BadEntityException("entity lacks default state");

		entity.addState(StateParser.parseDefaultState(
			rest.substring(i, rest.length()), entity));
		i += StateParser.getEnd();

		while (i < rest.length())
		try {
			entity.addState(StateParser.parse(
				rest.substring(i, rest.length()), entity));

			i += StateParser.getEnd();

		} catch (final Exception e) {
			System.err.printf(
				"SummonSpellParser :: %s while parsing motions for %s%n",
				e, spellName);

			while (i < rest.length() && rest.charAt(i) != '}')
				++i;
			++i;
		}

		return new Spell(spellName, castingTime, spellDuration, results);
	}

	private static int readNames(final String str, final Entity ent) {
		final Matcher
			matcher = Pattern.compile("(.*)" + Utils.EOL_REGEX).matcher(str);

		int pos = 0;
		while (matcher.find()) {

			final String line = Utils.toLower(matcher.group(1).trim());
			if (line.length() == 0)
				continue;
			if (!isValidNameChar(line.charAt(0)))
				break;

			ent.addName(line);

			pos += matcher.group(0).length();
		}

		if (ent.getNames().size() == 0)
			throw new BadEntityException("entity must have at least one name");

		return pos;
	}

	private static boolean isValidNameChar(final char c) {
		return c <= 'z' && c >= 'a';
	}
}

final class BadEntityException extends InputMismatchException {
	public BadEntityException(final String msg) {
		super(msg);
	}
}

final class SummonSpellConsequencePredicate
	extends ResultParser.ConsequencePredicate {

	private static SummonSpellConsequencePredicate
		instance = new SummonSpellConsequencePredicate();

	public static SummonSpellConsequencePredicate getInstance() {
		return instance;
	}

	public boolean accept(final String cons, final Result res) {
		return
			acceptFailure(cons, res) ||
			acceptByte("sanity",   Result.Consequence.Type.SANITY,   cons, res) ||
			acceptJust("gameover", Result.Consequence.Type.GAMEOVER, cons, res) ||
			acceptJust(
				"realgameover", Result.Consequence.Type.REALGAMEOVER, cons, res);
	}
}
