// File created: 2007-10-23 20:00:14

package ope.adventure.util;

import java.util.Set;

// binary tree, leaves are strings, only root may be DEFAULT
public final class BooleanExpression {
	public enum Symbol {
		AND, OR, NOT, DEFAULT, STRING
	}

	private final Symbol            sym;
	private final String            str;
	private final BooleanExpression left, right;

	public BooleanExpression(final Symbol s) {
		sym = s;
		str = null;
		left = right = null;
	}
	public BooleanExpression(final String s) {
		sym = Symbol.STRING;
		str = s;
		left = right = null;
	}
	public BooleanExpression(final Symbol s, final BooleanExpression l) {
		sym = s;
		str = null;
		left = l;
		right = null;
	}
	public BooleanExpression(
		final Symbol s,
		final BooleanExpression l, final BooleanExpression r
	) {
		sym = s;
		str = null;
		left = l;
		right = r;
	}

	public Symbol getSym() { return sym; }
	public String getStr() { return str; }

	public BooleanExpression getLeft () { return left; }
	public BooleanExpression getRight() { return right; }

	public boolean matches(final Set<String> trueVals) {
		switch (sym) {
			case DEFAULT: return true;
			case STRING: return trueVals.contains(str);

			case NOT: return !left.matches(trueVals);
			case AND: return left.matches(trueVals) && right.matches(trueVals);
			case OR:  return left.matches(trueVals) || right.matches(trueVals);
		}
		throw new IllegalStateException(
			"BooleanExpression has a symbol not handled in matches()");
	}
}
