// File created: 2007-10-05 17:44:14

package ope.adventure.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
//import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
//import java.util.Set;
import java.util.regex.Pattern;

public final class Utils {
	private Utils() {}

	public static final Pattern
		EOL_REGEX = Pattern.compile("(?:\\r\\n?|[\\n\\u0085\\u2028\\u2029])");

	public static String[] lineSplit(final String s) {
		return EOL_REGEX.split(s);
	}

	public static String join(final String[] a) {
		return join(Arrays.asList(a), "");
	}
	public static String join(final List<String> a) {
		return join(a, "");
	}
	public static String join(final List<String> a, final String sep) {
		final StringBuilder sb = new StringBuilder();
		for (final String s : a.subList(0, a.size()-1))
			sb.append(s).append(sep);
		return sb.append(a.get(a.size()-1)).toString();
	}

	public static String toLower(final String s) {
		return s.toLowerCase(Locale.ENGLISH);
	}

	public static String chomp(final String s, final char c) {
		if (s.charAt(s.length() - 1) == c)
			return s.substring(0, s.length() - 1);
		else
			return s;
	}

	public static int skipWhiteSpace(final int pos, final String str) {
		int i = pos;
		while (i < str.length() && Character.isWhitespace(str.charAt(i)))
			++i;
		return i;
	}

	/*public static List<T> union(final List<T>... ls) {
		if (a == null || b == null)
			return null;

		final Set<T> s = new HashSet<T>();
		for (final List<T> l : ls)
			s.addAll(l);
		return Arrays.asList(Arrays.sort(s.toArray(new T[0])));
	}*/

	public static String readLineSkipComments(final Scanner scan) {
		String s;
		do s = toLower(scan.nextLine().trim());
		while (s.charAt(0) == '#');
		return s;
	}

	public static String getContents(final InputStream s) {
		try {
			return getContents(
				new BufferedReader(new InputStreamReader(s, "UTF-8")));

		} catch (final UnsupportedEncodingException e) {
			// "Every implementation of the Java platform is required to
			// support the following standard charsets."
			// UTF-8 being one of them. Hooray for checked exceptions!
			assert false;
			// "Missing return statement"
			return null;
		}
	}
	public static String getContents(final Readable s) {
		return new Scanner(s).useDelimiter("$").next();
	}
}
